<?php
abstract class Module
{
	public $id = false;

	public $name;

	public $version;

	public $displayName;

	public $description;

	public $picto;

	public $hook;

	public $category;

	public $visible;

	public $module;

	public $valid;

	public $errors;

	protected $_path = NULL;

	protected static $currentIndex;

	public static $CSS = array();

	public static $JS = array();
	
	public function __construct()
	{
		global $currentIndex;

		self::$currentIndex = $currentIndex.'&configure='.$this->name;

		if ($this->name != NULL)
			$this->_path = _BASE_URI_.'modules/'.$this->name.'/';
	}

	private static function getXMLModules()
	{
		return new SimpleDOM(_FILE_MODULES_, NULL, true);
	}

	private static function getXMLHooks()
	{
		return new SimpleDOM(_FILE_HOOKS_, NULL, true);
	}

	public static function getList($install = false, $categories = true)
	{
		global $kameleon_user;

		$tabModules = array();
		$handle = opendir(_MODULES_DIR_);
		while($file = readdir($handle))
		{
			if(is_dir(_MODULES_DIR_.$file) && is_file(_MODULES_DIR_.$file.'/'.$file.'.php') && $file != '.' && $file != '..')
			{
				$module = self::getInstanceByName($file);
				if($module)
				{
					//Test, si le paramètre est passé à "true", que le module est installé ou si le paramètre est à "false" que le module n'est pas installé
					if(($install && $module->isInstall()) || (!$install && !$module->isInstall()))
					{
						//Test si le module est visible pour les utilisateurs normaux ou l'affiche dans tout les cas pour l'admin
						if($kameleon_user->isAdmin() || $module->visible)
						{
							if($categories)
							{
								if(isset($tabModules[$module->category]))
									$tabModules[$module->category][] = $module;
								else
									$tabModules[$module->category][0] = $module;
							}
							else
								$tabModules[] = $module;
						}
					}
				}
			}
        }
        closedir($handle);
		return $tabModules;
	}

	public static function getListForFront()
	{
		global $kameleon_user;

		$tabModules = array();
		$handle = opendir(_MODULES_DIR_);
		while($file = readdir($handle))
		{
			if(is_dir(_MODULES_DIR_.$file) && is_file(_MODULES_DIR_.$file.'/'.$file.'.php') && $file != '.' && $file != '..')
			{
				$module = self::getInstanceByName($file);
				if($module)
				{
					if($module->isInstall())
					{
						$tabModules[] = $module->name;
					}
				}
			}
        }
        closedir($handle);
		return $tabModules;
	}

	public static function getHook($hook_name)
	{
		$moduleList = Module::getHookListModule($hook_name);
		$content = '';
		foreach($moduleList as $module)
		{
			$content .= method_exists($module, 'display_'.$hook_name) ? $module->{'display_'.$hook_name}() : '';
		}
		return $content;
	}

	public static function getInstanceByName($moduleName)
	{
		$module = explode('=', (String)$moduleName);
		if(file_exists(_MODULES_DIR_.$module[0].'/'.$module[0].'.php'))
		{
			include_once(_MODULES_DIR_.$module[0].'/'.$module[0].'.php');
			if(!class_exists($module[0], false))
				return false;
			if(isset($module[1]))
				return (new $module[0]($module[1]));
			return (new $module[0]);
		}
		return false;
	}

	public static function getModuleFront($module)
	{
		$module = Module::getInstanceByName($module);
		return method_exists($module, 'getFront') ? $module->getFront() : '';
	}

	public static function getHookListModule($hook_name)
	{
		$xml = self::getXMLHooks();
		$moduleList = array();
		foreach($xml->$hook_name as $modules)
			if((String)$modules != '')
			{
				$tabModule = explode(',', (String)$modules);
				foreach($tabModule as $module)
					$moduleList[] = Module::getInstanceByName($module);
			}
		return $moduleList;
	}

	public static function getHookList($all = true)
	{
		$xml = self::getXMLHooks();
		$hookList = array();
		$i = 0;
		foreach($xml as $hook)
		{
			if($hook->getName() != 'NOT_ASSIGN' || $all)
			{
				$hookList[$i]['id'] = $hook->getName();
				$hookList[$i]['name'] = $hook['name'];
				$i++;
			}
		}
		return $hookList;
	}

	public static function display($file, $template)
	{
		global $smarty;

		$smarty->assign('modules_dir', _BASE_URI_MODULES_);
		$result = $smarty->fetch(_MODULES_DIR_.basename($file, '.php').'/'.$template);
		return $result;
	}

	public function install()
	{
		if(!$this->isInstall())
		{
			$xml = $this->getXMLModules();
			$xml->addChild($this->name);
			$xml->asXML(_FILE_MODULES_);

			if($this->hook)
				$this->registerModuleHook($this->hook, $this->name);
			return true;
		}
		return false;
	}

	public function uninstall()
	{
		if($this->isInstall())
		{
			$xml = $this->getXMLModules();
			$moduleName = $this->name;
			unset($xml->$moduleName);
			$xml->asXML(_FILE_MODULES_);

			if($this->removeModuleHooks($moduleName))
				return Page::deleteModule($moduleName);
			return false;
		}
		return false;
	}

	public static function registerModuleHook($hookName, $moduleName)
	{
		$xml = self::getXMLHooks();
		if($xml->$hookName)
		{
			$modules = explode(',', $xml->$hookName);
			if(!in_array($moduleName, $modules))
			{
				$xml->$hookName .= ($xml->$hookName != '' ? ',' : '' ).$moduleName;
				return $xml->asXML(_FILE_HOOKS_);
			}
		}
		return false;
	}

	public static function removeModuleHooks($moduleName, $hookName = false)
	{
		$xml = self::getXMLHooks();

		if($hookName)
			$modulesHooks = $xml->xpath("/hooks/".$hookName."[contains(.,'".$moduleName."')]");
		else
			$modulesHooks = $xml->xpath("/hooks/*[contains(.,'".$moduleName."')]");

		foreach($modulesHooks as $moduleHook)
		{
			$modules = explode(',',$moduleHook);
			foreach($modules as $k => $module)
			{
				$module = explode('=', (String)$module);
				if($module[0] == $moduleName)
				{
					unset($modules[$k]);
					continue;
				}
			}
			$moduleHook[0] = implode(',',$modules);
		}
		return $xml->asXML(_FILE_HOOKS_);
	}

	public static function removeModuleId($moduleId)
	{
		$xml = self::getXMLHooks();

		$modulesHooks = $xml->xpath("/hooks/*[contains(.,'".$moduleId."')]");

		foreach($modulesHooks as $moduleHook)
		{
			$modules = explode(',',$moduleHook);
			foreach($modules as $k => $module)
			{
				if($module == $moduleId)
				{
					unset($modules[$k]);
					continue;
				}
			}
			$moduleHook[0] = implode(',',$modules);
		}
		return $xml->asXML(_FILE_HOOKS_);
	}

	public function isInstall()
	{
		$xml = $this->getXMLModules();
		$moduleName = $this->name;
		return isset($xml->$moduleName);
	}

	public function findTranslation()
	{
		$dirModule = _MODULES_DIR_.$this->name.'/';

		$tplRegex = '/\{l s="(.*[^\\\\])" mod="(.+)"\}/U';
		$phpRegex = '/->l\("(.*[^\\\\])"(, \'(.+)\')?(, (.+))?\)/U';

		$handle = opendir($dirModule);
		$tabTranslatation = array();
		while($file = readdir($handle))
		{
			if(substr($file, -4) == '.tpl' || $file == $this->name.'.php')
			{
				$dirFile = $dirModule.$file;
				$handfleFile = fopen($dirFile, "r");
				$matches = array();

				if(substr($file, -4) == '.tpl')
					$regex = $tplRegex;
				elseif($file == $this->name.'.php')
					$regex = $phpRegex;

				preg_match_all($regex, fread($handfleFile, filesize($dirFile)), $matches);
				fclose($handfleFile);
				foreach ($matches[1] as $key)
					$tabTranslatation[] = $key;
			}
		}
		closedir($handle);
		return array_unique($tabTranslatation);
	}

	public function saveTranslation()
	{
		$handle = fopen(_MODULES_DIR_.$this->name.'/'.Tools::getvalue('lang').'.php', 'w');
		$output = "<?php\nglobal \$_MODULE;\n\$_MODULE = array();\n";
		foreach(Tools::getvalue('md5') as $k => $v)
			if(Validate::isMd5($k))
				$output .= '$_MODULE[\'<{'.$this->name.'}>'.$k.'\'] = \''.addslashes($v).'\';'."\n";
		fwrite($handle, $output);
		fclose($handle);
	}

	public static function savePosition()
	{
		$xml = self::getXMLHooks();
		foreach($xml as $hook)
		{
			$hookName = $hook->getName();
			$hook[0] = Tools::isSubmit($hookName) ? implode(",",Tools::getvalue($hookName)) : '';
		}
		$xml->asXML(_FILE_HOOKS_);
	}

	public function l($string, $lang = false)
	{
		global $_MODULES, $_MODULE, $cookie;

		$file = _MODULES_DIR_.$this->name.'/'.($lang ? $lang : $cookie->lang).'.php';
		if(Tools::file_exists_cache($file) AND include_once($file))
			$_MODULES = !empty($_MODULES) ? array_merge($_MODULES, $_MODULE) : $_MODULE;
		else
			return(str_replace('"', '&quot;', $string));
		if(!is_array($_MODULES))
			return(str_replace('"', '&quot;', $string));

		$string2 = str_replace('\'', '\\\'', $string);
		$currentKey = '<{'.$this->name.'}>'.md5($string2);

		if(key_exists($currentKey, $_MODULES))
			$ret = stripslashes($_MODULES[$currentKey]);
		else
			$ret = $string;
		return str_replace('"', '&quot;', $ret);
	}
}
