<?php
class Upload
{
    private $file;
	
    private $sizeImgLimit;

    private $sizeDocLimit;

    function __construct($sizeImgLimit = 0, $sizeDocLimit = 0)
	{
		$this->sizeImgLimit = $sizeImgLimit;
		if(!$this->sizeImgLimit)			
			$this->sizeImgLimit = Configuration::get('uploadimgsizemax') * 1024 * 1024;

		$this->sizeDocLimit = $sizeDocLimit;
		if(!$this->sizeDocLimit)			
			$this->sizeDocLimit = Configuration::get('uploaddocsizemax') * 1024 * 1024;
		

        if(isset($_GET['qqfile']))
            $this->file = new qqUploadedFileXhr();
        elseif(isset($_FILES['qqfile']))
            $this->file = new qqUploadedFileForm();
        else
            $this->file = false;
    }
    
    private function checkServerSettings()
	{        
        $postSize = $this->toBytes(ini_get('post_max_size'));
        $uploadSize = $this->toBytes(ini_get('upload_max_filesize'));        
        
        return !($postSize < $this->sizeImgLimit || $postSize < $this->sizeDocLimit || $uploadSize < $this->sizeImgLimit || $uploadSize < $this->sizeDocLimit);
    }
    
    private function toBytes($str)
	{
        $val = trim($str);
        $last = strtolower($str[strlen($str)-1]);
        switch ($last)
		{
            case 'g': $val *= 1024;
            case 'm': $val *= 1024;
            case 'k': $val *= 1024;        
        }
        return $val;
    }
    
    function handleUpload($uploadDirectory, $keepName = true, $newName = false)
	{
		/** issue du 15 janvier soumis par Léon */
		/*if(!$this->checkServerSettings())
			 return array('error' => 'Augmenter post_max_size et upload_max_filesize à '.max(1, $this->sizeLimit / 1024 / 1024).' M');*/
		
        if (!is_writable($uploadDirectory))
            return array('error' => "Impossible d'écrire dans le dossier (problème de droit)");
        
        if (!$this->file)
            return array('error' => 'Pas de fichier à uploader.');
        
        $size = $this->file->getSize();
        
        if ($size == 0)
            return array('error' => 'Fichier vide');
        
        // if ($size > $this->sizeLimit)
        //     return array('error' => 'Fichier trop lourd');
        
		$completeFilename = $this->file->getName();
		
		$arrayFileName = explode('.', $completeFilename);
		$ext = strtolower(array_pop($arrayFileName));
		$filename = $keepName ? strtolower(str_clean(implode('.', $arrayFileName))).'.'.$ext : $newName.'.'.$ext;

        if ($this->file->save($uploadDirectory . $filename))
		{
			if (getimagesize($uploadDirectory . $filename)) {
				list($width, $height, $type, $attr) = getimagesize($uploadDirectory . $filename);
				if ($height > 768) {
					$newHeight = 768;
					$newWidth = $width * $newHeight / $height;
					if (Configuration::get('redimAuto') == 1)
						ImageManager::resize($uploadDirectory . $filename, $uploadDirectory . $filename, $newWidth, $newHeight, '#ffffff', 'jpg');
				}
			}
            return array(
				'success' => true,
				'filename' => $filename
			);
        }
		else
            return array('error'=> 'Could not save uploaded file.' .
                'The upload was cancelled, or server error encountered');
    }
	
	public static function validateUpload($filename, $mime_type_list = null, $type = 'file')
	{
		if (!$mime_type_list)
		{
			if($type == 'file')
				$mime_type_list = array(
					'image/gif',
					'image/jpg',
					'image/jpeg',
					'image/pjpeg',
					'image/png',
					'image/x-png',
					'application/pdf',
					'application/zip',
					'application/rar',
					'application/msword',
					'application/vnd.ms-excel',
					'multipart/x-zip',
					'multipart/x-gzip'
				);
			elseif($type == 'image')
				$mime_type_list = array(
					'image/gif',
					'image/jpg',
					'image/jpeg',
					'image/pjpeg',
					'image/png',
					'image/x-png'
				);
		}

		// Detect mime content type
		$mime_type = false;

		// Try 4 different methods to determine the mime type
		if (function_exists('finfo_open'))
		{
			$const = defined('FILEINFO_MIME_TYPE') ? FILEINFO_MIME_TYPE : FILEINFO_MIME;
			$finfo = finfo_open($const);
			$mime_type = finfo_file($finfo, $filename);
			finfo_close($finfo);
		}
		elseif (function_exists('mime_content_type'))
			$mime_type = mime_content_type($filename);
		elseif (function_exists('exec'))
		{
			$mime_type = trim(exec('file -b --mime-type '.escapeshellarg($filename)));
			if (!$mime_type)
				$mime_type = trim(exec('file --mime '.escapeshellarg($filename)));
			if (!$mime_type)
				$mime_type = trim(exec('file -bi '.escapeshellarg($filename)));
		}
		if(!$mime_type)
		{
			$tmp = array();
			$tmp = explode('.',$filename);
			$ext_type = strtolower(array_pop($tmp));
			if($type == 'file')
				$ext_type_list = array(
					'png',
					'jpg',
					'gif',
					'jpeg',
					'pdf',
					'doc',
					'docx',
					'xls',
					'xlsx',
					'zip',
					'rar'
				);
			elseif($type == 'image')
				$ext_type_list = array(
					'png',
					'jpg',
					'gif',
					'jpeg'
				);
			
			// For each allowed MIME type, we are looking for it inside the current MIME type
			foreach ($ext_type_list as $ext)
				if (strstr($ext_type, $ext))
					return true;
			return false;
		}
		
		// For each allowed MIME type, we are looking for it inside the current MIME type
		foreach ($mime_type_list as $type)
			if (strstr($mime_type, $type))
				return true;
		return false;
	}
}

class qqUploadedFileXhr
{
    public function save($path)
	{    
        $input = fopen("php://input", "r");
        $temp = tmpfile();
        $realSize = stream_copy_to_stream($input, $temp);
        fclose($input);
        
        if ($realSize != $this->getSize()){            
            return false;
        }
        
        $target = fopen($path, "w");        
        fseek($temp, 0, SEEK_SET);
        stream_copy_to_stream($temp, $target);
        fclose($target);
        
        return true;
    }
	
    public function getName()
	{
        return $_GET['qqfile'];
    }
	
    public function getSize()
	{
        if (isset($_SERVER["CONTENT_LENGTH"]))
            return (int)$_SERVER["CONTENT_LENGTH"];            
        else
            throw new Exception('Getting content length is not supported.');   
    }   
}

class qqUploadedFileForm
{
    public function save($path)
	{
        if(!move_uploaded_file($_FILES['qqfile']['tmp_name'], $path))
            return false;
		chmod($path, 0664);
        return true;
    }
	
    public function getName()
	{
        return $_FILES['qqfile']['name'];
    }
	
    public function getSize()
	{
        return $_FILES['qqfile']['size'];
    }
}